#ifndef _JIBAPI_H_
#define _JIBAPI_H_

/***************************************************************************
 *
 *         JiBApi.h (Include file for the iButton forJava API)  
 *
 *                          { Ver 1.00 06/09/98 }
 *
 * {TAC}
 ***************************************************************************/
/*
 $Workfile: jibapi.h $
 $Revision: 1.1 $
 $Date: 2001/01/31 21:36:10 $
 $Author: hal $
 $Modtime: 3/10/99 9:58a $
 $Log: jibapi.h,v $
 Revision 1.1  2001/01/31 21:36:10  hal
 Initial checkin of iButton support files.

* 
* 4     3/31/99 8:49a Tomc
* 
* 3     2/18/99 1:30p Tomc
* 
* 2     12/17/98 10:21a Tomc
* 
* 1     12/15/98 9:31a Tomc
*/

#ifndef _INC_WINDOWS
#ifndef CIB_UNIX
#include "windows.h"
#endif
#endif

#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif

#ifdef WIN32
#define DLLEXPORT __stdcall
#pragma pack(1)
#endif

#ifdef WIN16
#define DLLEXPORT far _export pascal
#endif

#include "cibtypes.h"
#include "adapter.h"

/*
 *    API defines
 */

#define MAX_SEND            255      /* Maximum send buffer size */
#define MAX_RECEIVE         2048     /* Maximum receive buffer size */
#define MAX_JIB_NUM         16       /* Maximum number of CiBs on system */
#define MAX_BUF_SIZE        256 
#define MAX_PIN_SIZE        8
#define MAX_AID_SIZE        16
/* maximum data bytes that can be sent in a single packet */
#define MAX_APDU_SIZE       114

#define JIB_APDU_CLA_COMMAND_PROC (BYTE)0xd0
#define JIB_APDU_CLA_LOAD_APPLET  (BYTE)0xd0
#define JIB_APDU_CLA_SELECT       (BYTE)0x00
#define JIB_APDU_INS_COMMAND_PROC (BYTE)0x95
#define JIB_APDU_INS_LOAD_APPLET  (BYTE)0xa6
#define JIB_APDU_INS_SELECT       (BYTE)0xa4
#define JIB_APDU_P1_LOAD_APPLET   (BYTE)0x01
#define JIB_APDU_P1_CONTINUE_LOAD (BYTE)0x02
#define JIB_APDU_P1_SELECT        (BYTE)0x04
#define JIB_APDU_P1_COMMAND_ADMIN (BYTE)0x00
#define JIB_APDU_P1_COMMAND_INFO  (BYTE)0x01
#define JIB_APDU_P1_COMMAND_STATS (BYTE)0x02
#define JIB_APDU_P1_COMMAND_AID   (BYTE)0x03
#define JIB_APDU_LE_DEFAULT       (BYTE)0x00
#define JIB_APDU_UNUSED           (BYTE)0x00

#ifndef _SYS_TYPES_H
typedef unsigned char  uchar;
typedef unsigned short ushort;
typedef unsigned long  ulong;
#endif

#ifdef _BORLANDC_
typedef BOOL FAR *LPBOOL;      
#endif

/*
 *   Structure definitions
 */
typedef struct _CMDPACKET
{
   BYTE Len;
   BYTE CmdByte;
   BYTE GroupID;
   BYTE CmdData[MAX_SEND]; 
}
CMDPACKET, *PCMDPACKET, NEAR *NPCMDPACKET, FAR *LPCMDPACKET;

typedef struct _RETPACKET      /* Firmware return packet */
{
   BYTE CSB;
   BYTE GroupID;
   BYTE DataLen;
   BYTE CmdData[MAX_RECEIVE];
}
RETPACKET, *PRETPACKET, NEAR *NPRETPACKET, FAR *LPRETPACKET;

typedef struct _COMMANDAPDU  /* Command APDU */
{
  BYTE   Header[4];
  BYTE   Lc;
  LPBYTE Data;
  BYTE   Le;
} COMMANDAPDU, *LPCOMMANDAPDU;

/* Field access defines */
#define CLA Header[0]
#define INS Header[1]
#define P1  Header[2]
#define P2  Header[3]

typedef struct _RESPONSEAPDU /* Response APDU */
{
  WORD   Len;
  LPBYTE Data;
  WORD   SW;
} RESPONSEAPDU,*LPRESPONSEAPDU;

typedef struct _JIBMASTERPIN /* iButton Master PIN */
{
  BYTE Len;
  BYTE Data[MAX_PIN_SIZE];
} JIBMASTERPIN,*LPJIBMASTERPIN;

typedef struct _AID /* Applet AID */
{
  BYTE Len;
  BYTE Data[MAX_AID_SIZE];
} AID, *LPAID;

/*
 *     API communication error codes
 */
#define ERR_NO_JIBS_FOUND        0xF000
#define ERR_BAD_JIB_ROM          0xF100
#define ERR_JIB_NOT_FOUND        0xF200
#define ERR_ADAPTER_NOT_FOUND    0xF300
#define ERR_COMM_FAILURE         0xF400
/*
 *     General API Errors
 */
#define ERR_API_INVALID_PARAMETER 0xFA00
#define ERR_API_MEMORY_ALLOCATION 0xFA01
/*
 *     ISO Errors & JiB Errors
 */
#define ERR_ISO_NORMAL_00             0x9000
#define ERR_NEXT_LOAD_PACKET_EXPECTED 0x6301

#define COMMIT_BUFFER_BYTES_PER_FIELD 0x09

#ifdef __cplusplus
extern "C" {
#endif

/* API Commands */
DWORD           DLLEXPORT GetJiBAPIVersion();
void            DLLEXPORT SetPIN(LPJIBMASTERPIN p_lpMasterPIN);
void            DLLEXPORT SetDefaultExecTime(WORD p_ExecTimeMS);
LPRESPONSEAPDU  DLLEXPORT SendAPDU(LPCOMMANDAPDU  p_lpCommandAPDU, 
                                    WORD           p_ExecTimeMS);
LPRESPONSEAPDU  DLLEXPORT Process(BYTE   p_CLA, 
                                   BYTE   p_INS, 
                                   BYTE   p_P1, 
                                   BYTE   p_P2, 
                                   BYTE   p_Lc, 
                                   LPBYTE p_lpData,
                                   WORD   p_RunTimeMS);
LPRESPONSEAPDU  DLLEXPORT Select(LPAID p_lpAID);                                  
LPRESPONSEAPDU  DLLEXPORT MasterErase();
LPRESPONSEAPDU  DLLEXPORT GetFreeRam();
LPRESPONSEAPDU  DLLEXPORT GetFreeRamPerBank();
//LPRESPONSEAPDU  DLLEXPORT ReadFreeRam();            /* Deprecated */
LPRESPONSEAPDU  DLLEXPORT GetFirmwareVersionString();
//LPRESPONSEAPDU  DLLEXPORT ReadFirmwareVersionID();  /* Deprecated */
LPRESPONSEAPDU  DLLEXPORT GetEphemeralGCMode();
LPRESPONSEAPDU  DLLEXPORT SetEphemeralGCMode(BYTE p_Mode);
LPRESPONSEAPDU  DLLEXPORT GetAppletGCMode();
LPRESPONSEAPDU  DLLEXPORT SetAppletGCMode(BYTE p_Mode);
LPRESPONSEAPDU  DLLEXPORT GetCommandPINMode();
LPRESPONSEAPDU  DLLEXPORT SetCommandPINMode(BYTE p_Mode);
LPRESPONSEAPDU  DLLEXPORT GetLoadPINMode();
LPRESPONSEAPDU  DLLEXPORT SetLoadPINMode(BYTE p_Mode);
LPRESPONSEAPDU  DLLEXPORT GetRestoreMode();
LPRESPONSEAPDU  DLLEXPORT SetRestoreMode(BYTE p_Mode);
LPRESPONSEAPDU  DLLEXPORT GetExceptionMode();
LPRESPONSEAPDU  DLLEXPORT SetExceptionMode(BYTE p_Mode);
LPRESPONSEAPDU  DLLEXPORT GetISOExceptionMode();
LPRESPONSEAPDU  DLLEXPORT SetISOExceptionMode(BYTE p_Mode);
LPRESPONSEAPDU  DLLEXPORT GetErrorReportMode();
LPRESPONSEAPDU  DLLEXPORT SetErrorReportMode(BYTE p_Mode);
LPRESPONSEAPDU  DLLEXPORT GetCommitBufferSize();
LPRESPONSEAPDU  DLLEXPORT GetCommitBufferFields();
LPRESPONSEAPDU  DLLEXPORT SetCommitBufferSize(short p_SizeInBytes);
LPRESPONSEAPDU  DLLEXPORT SetCommitBufferFields(short p_NumberOfFields);
LPRESPONSEAPDU  DLLEXPORT GetATR();
LPRESPONSEAPDU  DLLEXPORT GetRealTimeClock();
LPRESPONSEAPDU  DLLEXPORT GetRandomBytes(short p_NumBytes);
LPRESPONSEAPDU  DLLEXPORT GetAIDByNumber(BYTE p_AIDNum);
LPRESPONSEAPDU  DLLEXPORT GetLastJCREError();
LPRESPONSEAPDU  DLLEXPORT GetAllAIDs();
LPRESPONSEAPDU  DLLEXPORT GetActivationTimeRemaining();
LPRESPONSEAPDU  DLLEXPORT GetVerifyLoadWithIdMode();
LPRESPONSEAPDU  DLLEXPORT SetVerifyLoadWithIdMode(BYTE p_Mode);
LPRESPONSEAPDU  DLLEXPORT GetPORCount();
LPRESPONSEAPDU  DLLEXPORT SetMasterPIN(LPJIBMASTERPIN p_lpNewMasterPin);
LPRESPONSEAPDU  DLLEXPORT DeleteSelectedApplet();
LPRESPONSEAPDU  DLLEXPORT DeleteAppletByNumber(BYTE p_AppletNumber);
LPRESPONSEAPDU  DLLEXPORT DeleteAppletByAID(LPAID p_lpAID);
LPRESPONSEAPDU  DLLEXPORT LoadApplet(LPBYTE p_lpAppletBuffer, 
                                      DWORD  p_AppletLen,
                                      LPAID  p_lpAID);

void    DLLEXPORT SetJiBSearchParams(BYTE p_SPNum, char *p_lpDevName[]);
void    DLLEXPORT SetJiBSearchParamsEx(BYTE p_SPNum, char *p_lpDevName[], BYTE p_ParallelSearch);
void    DLLEXPORT ReleaseJiBAPIResources();
LPBYTE  DLLEXPORT FindJiBs(LPBYTE p_lpJiBNum);
BOOL    DLLEXPORT SelectJiB(LPBYTE lpCiBRomPtr);
WORD    DLLEXPORT GetJiBError();

void   SetJiBError(WORD ErrCode);

/*
 *  Low level comm functions
 */
DWORD DLLEXPORT GetCiBCommVersion();
BYTE  DLLEXPORT SearchPorts(LPBYTE, LPBYTE, LPBOOL, LPIBHOST);
WORD  DLLEXPORT SendCiBMessage(LPBYTE, WORD, WORD, PIBADDR);
WORD  DLLEXPORT RecvCiBMessage(LPBYTE, LPWORD, PIBADDR);

#ifdef __cplusplus
}
#endif

#endif/* _JIBAPI_H_ */